<?php
/* --------------------------------------------------------------
   PermissionsRepository.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission\Repositories;

use Gambio\Core\Permission\Model\Permission;
use Gambio\Core\Permission\PermissionDefinition;
use Gambio\Core\Permission\PermissionRepository;
use Gambio\Core\Permission\UserId;

/**
 * Class PermissionsRepository
 *
 * @package Gambio\Core\Auth\Repositories
 */
class PermissionsRepository implements PermissionRepository
{
    private const MAIN_ADMIN_ID = 1;
    
    /**
     * @var PermissionsReader
     */
    private $reader;
    
    
    /**
     * PermissionsRepository constructor.
     *
     * @param PermissionsReader $reader
     */
    public function __construct(PermissionsReader $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getPermission(
        UserId $id,
        PermissionDefinition $permissionDefinition
    ): \Gambio\Core\Permission\Permission {
        if ($id->userId() === self::MAIN_ADMIN_ID) {
            return Permission::create($id, $permissionDefinition, true);
        }
        
        $permissionGranted = $this->reader->isPermissionGranted($id, $permissionDefinition);
        
        return Permission::create($id, $permissionDefinition, $permissionGranted);
    }
}